<?php
/*
=====================================================
 File: textversion.php
=====================================================
*/

@session_start();
@error_reporting(E_ALL ^ E_NOTICE);
@ini_set('display_errors', true);
@ini_set('html_errors', false);
	
define('DATALIFEENGINE', true);

if(!defined('FORUM_SUB_DOMAIN'))
{
	define('ROOT_DIR', '../..');
}

define('ENGINE_DIR', ROOT_DIR.'/engine');

include ENGINE_DIR.'/data/config.php';
include ENGINE_DIR.'/data/forum_config.php';

$_TIME = time()+($config['date_adjust']*60);

$tpl = array();

$tpl['charset'] = $config['charset'];

include_once ROOT_DIR.'/language/'.$config['langs'].'/website.lng';
require_once ENGINE_DIR.'/modules/functions.php';
require_once ENGINE_DIR.'/classes/mysql.php';
require_once ENGINE_DIR.'/data/dbconfig.php';
require_once ENGINE_DIR.'/forum/sources/components/init.php';
require_once ENGINE_DIR.'/forum/sources/components/text_skin.php';

// ********************************************************************************
// FORUM URL
// ********************************************************************************
if (!$forum_config['forum_url'])
{
	if ($forum_config['mod_rewrite'])
	{
		$forum_url = $config['http_home_url']."forum";
		
		$txt_url = $config['http_home_url']."forum/textversion.html";
	}
	
	else
	{
		$forum_url = $config['http_home_url']."index.php?do=forum&";
		
		$txt_url = $config['http_home_url']."engine/forum/textversion.php";
	}
	
	$a_forum_url = $config['http_home_url']."index.php?do=forum&";
}

else
{
	if ($forum_config['mod_rewrite'])
	{
		$forum_url = $forum_config['forum_url'];
		
		$txt_url = $forum_config['forum_url']."/textversion.html";
	}
	
	else
	{
		$forum_url = $forum_config['forum_url']."/index.php?";
		
		$txt_url = $forum_config['forum_url']."/textversion.php";
	}
	
	$a_forum_url = $forum_config['forum_url']."/index.php?";
}

if ($forum_config['mod_rewrite'])
{
	$c_url = $forum_url.'/category_';
	
	$f_url = $forum_url.'/forum_';
	
	$t_url = $forum_url.'/topic_';
}

else
{
	$c_url = $forum_url.'category=';
	
	$f_url = $forum_url.'showforum=';
	
	$t_utl = $forum_url.'showtopic=';
}

// ********************************************************************************
// USER GROUP
// ********************************************************************************
$user_group = get_vars ("usergroup");

if (!$user_group)
{
	$user_group = array ();
	
	$db->query("SELECT * FROM " . USERPREFIX . "_usergroups ORDER BY id ASC");
	
	while($row = $db->get_row())
	{
		$user_group[$row['id']] = array ();
		
		foreach ($row as $key => $value)
		{
			$user_group[$row['id']][$key] = $value;
		}
	}
	
	set_vars ("usergroup", $user_group);
	
	$db->free();
}

require_once ENGINE_DIR.'/modules/sitelogin.php';

if (!$is_logged)
{
	$member_id['user_group'] = 5;
}

function get_attachment ($tid, $sourse)
{
	global $db, $a_forum_url;
	
	$get_attachment = $db->query("SELECT * FROM " . PREFIX . "_forum_files WHERE topic_id = '$tid' and file_attach = '1'");
	
	while ($row = $db->get_row($get_attachment))
	{
		if ($row['file_type'] == "image")
		{
			$img_full = $config['http_home_url'].'uploads/forum/images/'.$row['onserver'];
			
			$attachment = "<img src=\"{$img_full}\" border=\"0\">";
		}
		
		elseif ($row['file_type'] == "thumb")
		{
			$img_full = $config['http_home_url'].'uploads/forum/images/'.$row['onserver'];
			
			$img_thumb = $config['http_home_url'].'uploads/forum/thumbs/'.$row['onserver'];
			
			$attachment = "<a href=\"{$img_full}\"><img src=\"{$img_thumb}\" border=\"0\"></a>";
		}
		
		else
		{
			$attachment_down = $a_forum_url."act=attachment&id=".$row['file_id'];
			
			$attachment = "<a href=\"$attachment_down\">{$row['file_name']}</a> ({$row['dcount']} | ".formatsize($row['file_size']).")";
		}
		
		$sourse = str_replace('[attachment='.$row['file_id'].']', $attachment, $sourse);
	}
	
	return $sourse;
}

function not_access()
{
	global $txt_url;
	
	@header ("Location: $txt_url");
}

$forum_config['topic_inpage'] = 150;
$forum_config['post_inpage']  = 50;

// ********************************************************************************
// TEXT VERSION
// ********************************************************************************
	$main_string = parse_url($_SERVER['REQUEST_URI']);
	
	$main_string = $main_string['query'];
	
	$act    = '';
	$id     = 0;
	$cstart = 0;
	
	$category_name = 0;
	$category_id   = 0;
	$forum_name    = 0;
	
	if (strstr($main_string, "-"))
	{
		list($main, $start) = explode("-", $main_string);
		
		$main_string = $main;
		$cstart      = $start;
	}
	
	if (preg_match( "#c\d#", $main_string))
	{
		$act = "category";
		
		$id    = intval( preg_replace( "#c(\d+)#", "\\1", $main_string ) );
	}
	
	if (preg_match( "#f\d#", $main_string))
	{
		$act = "forum";
		
		$id    = intval( preg_replace( "#f(\d+)#", "\\1", $main_string ) );
	}
	
	if (preg_match( "#t\d#", $main_string))
	{
		$act = "topic";
		
		$id    = intval( preg_replace( "#t(\d+)#", "\\1", $main_string ) );
	}
	
	switch ($act)
	{
// ********************************************************************************
// SHOW CATEGORY
// ********************************************************************************
		case "category":
		
		$category_id = $id;
		
		if ($forum_config['hide_forum']) $access_hide = "and access_read regexp '[[:<:]](".$member_id['user_group'].")[[:>:]]'";
		
		else $access_hide = "";
		
		$category_name = $cats_array[$id]['cat_name'];
		
		if ($id and $category_name)
		{
			$result = $db->query("SELECT * FROM ". PREFIX ."_forum_forums WHERE main_id = '$id' and parentid = '0' {$access_hide} ORDER by position");
			
			$tpl['content'] .= tpl_category ($id, $category_name);
			
			while ($row = $db->get_row($result))
			{
				$sub_forums = "";
				
				if ($sub_forums_array != 'empty')
				{
					foreach ($sub_forums_array as $value)
					{
						if ($row['id'] == $value['parentid'])
						{
							$sub_forums .= tpl_forum_sub ($value['id'], $value['name']);
						}
					}
				}
				
				$tpl['content'] .= tpl_forum ($row['id'], $row['name'], $row['posts'], $sub_forums);
			}
		}
		
		$tpl['content'] = tpl_forums_page ($tpl['content']);
		
		$tpl['content'] .= tpl_category_end ();
		
		$tpl['title'] = $forum_config['forum_title'] .' > '. $category_name;
		
		$tpl['full_version'] = $category_name;
		
		$tpl['full_version_link'] = $c_url . $id;
		
		break;
		
// ********************************************************************************
// SHOW FORUM
// ********************************************************************************
		case "forum":
		
		if ($cstart)
		{
			$cstart = $cstart - 1;
			$cstart = $cstart * $forum_config['topic_inpage'];
		}
		
		if ($forum_config['topic_sort'])
		{
			$sort_type = "last_date";
		}
		else
		{
			$sort_type = "tid";
		}
		
		if ($id)
		{
			$row_forum = $db->super_query("SELECT * FROM " . PREFIX . "_forum_forums WHERE id = '$id'");
			
			$check_read = check_access($row_forum['access_read']);
			
			$forum_name = $row_forum['name'];
			
			$password = $row_forum['password'];
			
			$category_id = $row_forum['main_id'];
			
			$count_all = $row_forum['topics'];
			
			if ($password)
			{
				$forum_cookie = $_COOKIE["dle_forum_{$fid}"];
				
				unset ($check_read);
				
				if (md5($password) == $forum_cookie)
				{
					$check_read = true;
				}
			}
			
			if ($check_read and $count_all)
			{
				$db->query("SELECT * FROM " . PREFIX . "_forum_topics WHERE forum_id = '$id' ".$WHERE." ORDER BY fixed, ".$sort_type." DESC LIMIT ".$cstart.",".$forum_config['topic_inpage']."");
				
				while ($row = $db->get_row())
				{
					if ($row['hidden']) $n_pre = $forum_config['forum_pr_modr'].' ';
					
					elseif (!$row['fixed']) $n_pre = $forum_config['forum_pr_imp'].' ';
					
					elseif ($row['frage'])  $n_pre = $forum_config['forum_pr_vote'].' ';
					
					else $n_pre = '';
					
					$tpl['content'] .= tpl_topic_list ($row['tid'], $n_pre, $row['title'], $row['post']);
				}
				
				if ($count_all > $forum_config['topic_inpage'])
				{
					$tpl['pages'] = tpl_pages ($cstart, $count_all, $forum_config['topic_inpage'], "?f{$id}");
				}
				
				$tpl['content'] = tpl_forum_page ($tpl['content']);
			}
			
			else
			{
				not_access();
			}
			
			$tpl['title'] = $forum_config['forum_title'] .' > '. $forum_name;
			
			$tpl['full_version'] = $forum_name;
			
			$tpl['full_version_link'] = $f_url . $id;
			
			$category_name = $cats_array[$category_id]['cat_name'];
		}
		
		else
		{
			not_access();
		}
		
		break;

// ********************************************************************************
// SHOW TOPIC
// ********************************************************************************
		case "topic":
		
		if ($cstart)
		{
			$cstart = $cstart - 1;
			$cstart = $cstart * $forum_config['post_inpage'];
		}
		
		if ($id)
		{
			$row_topic = $db->super_query("SELECT * FROM " . PREFIX . "_forum_topics WHERE tid = '$id'");
			
			$forum_id = $row_topic['forum_id'];
			
			$forum_name = $forums_array[$forum_id]['name'];
			
			$check_read = check_access($forums_array[$forum_id]['access_read']);
		}
		
		if ($row_topic['tid'] and $check_read and !$row_topic['hidden'])
		{
			$result_posts = $db->query("SELECT p.*, u.* FROM " . PREFIX . "_forum_posts AS p LEFT JOIN " . USERPREFIX . "_users AS u ON p.post_author=u.name WHERE p.topic_id = '$id' ORDER by pid LIMIT ".$cstart.",".$forum_config['post_inpage']."");
			
			$count_all = ($row_topic['post'] + 1);
			
			if ($count_all)
			{
				while ($row = $db->get_row ($result_posts))
				{
					if ($row['hidden'])
					{
						$row['post_text'] = "&nbsp;";
					}
					
					if ($member_id['forum_post'] >= $forum_config['post_hide'])
					{
						$row['post_text'] = preg_replace("'\[hide\](.*?)\[/hide\]'si", "\\1", $row['post_text']);
					}
					else
					{
						$hide_info = " !  {$forum_config[post_hide]} .";
						
						$row['post_text'] = preg_replace("'\[hide\](.*?)\[/hide\]'si", "<div>".$hide_info."</div>", $row['post_text']);
					}
					
					$row['post_date'] = strtotime($row['post_date']);
					
					$tpl['content'] .= tpl_post ($row['post_text'], $row['post_author'], show_date($row['post_date']));
				}
				
				if (stristr ($tpl['content'], "[attachment="))
				{
					$tpl['content'] = get_attachment ($id, $tpl['content']);
				}
				
				if ($count_all > $forum_config['post_inpage'])
				{
					$tpl['pages'] = tpl_pages ($cstart, $count_all, $forum_config['post_inpage'], "?t{$id}");
				}
			}
			
			else
			{
				not_access();
			}
			
			$tpl['title'] = $forum_config['forum_title'] .' > '. $row_topic['title'];
			
			$tpl['full_version'] = $row_topic['title'];
			
			$tpl['full_version_link'] = $t_url . $id;
			
			$category_id = $forums_array[$forum_id]['main_id'];
			
			$category_name = $cats_array[$category_id]['cat_name'];
		}
		
		else
		{
			not_access();
		}
		
		break;

// ********************************************************************************
// SHOW INDEX
// ********************************************************************************
		default:
		
		if ($forum_config['hide_forum']) $access_hide = "and access_read regexp '[[:<:]](".$member_id['user_group'].")[[:>:]]'";
		
		else $access_hide = "";
		
		$db->query("SELECT * FROM " . PREFIX . "_forum_category LEFT JOIN ". PREFIX ."_forum_forums ON ". PREFIX ."_forum_category.sid= ". PREFIX ."_forum_forums.main_id WHERE parentid = '0' {$access_hide} ORDER BY posi, position");
		
		for ($i = 0; $row = $db->get_row(); $i = $row['sid'])
		{
			$count++;
			
			if ($row['sid'] != $i)
			{
				if ($count > 1)
				{
					$tpl['content'] .= tpl_category_end ();
				}
				
				$tpl['content'] .= tpl_category ($row['main_id'], $row['cat_name']);
			}
			
			if ($row['name'])
			{
				$sub_forums = "";
				
				if ($sub_forums_array != 'empty')
				{
					foreach ($sub_forums_array as $value)
					{
						if ($row['id'] == $value['parentid'])
						{
							$sub_forums .= tpl_forum_sub ($value['id'], $value['name']);
						}
					}
				}
				
				$tpl['content'] .= tpl_forum ($row['id'], $row['name'], $row['posts'], $sub_forums);
				
			}
		}
		
		$tpl['content'] = tpl_forums_page ($tpl['content']);
		
		$tpl['title'] = $forum_config['forum_title'];
		
		$tpl['full_version'] = $forum_config['forum_title'];
		
		$tpl['full_version_link'] = $forum_url;
		
		break;
	}
	
	$tpl['nav'] = "<a href='{$txt_url}'>{$forum_config['forum_title']}</a>";
	
	if ($category_name)
	{
		$tpl['nav'] = $tpl['nav'] . "&nbsp;>&nbsp;<a href='{$txt_url}?c{$category_id}'>{$category_name}</a>";
	}
	
	if ($forum_name)
	{
		$tpl['nav'] = $tpl['nav'] . "&nbsp;>&nbsp;<a href='{$txt_url}?f{$id}'>{$forum_name}</a>";
	}
	
	tpl_main ($tpl);
	
?>